#!perl -T

use Test::More tests => 2;
use Test::Exception;

use Test::MockFile::Light module => 'Foo::Bar';

{
	package Foo::Bar;

	sub open_file {
		my ($class, $file_name) = @_;

		open my $fh, '<', $file_name or die $!;

		close $fh;
	}
}

my $file_name = $0;

lives_ok {
	open my $fh, '<', $file_name or die $!;
} 'opening file in the main module';

throws_ok {
	Foo::Bar->open_file($file_name);
} qr/No such file or directory/
, 'attempting to open file in the Foo::Bar module';
