/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.hector.HectorPath;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinFactory;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;
import net.sourceforge.plantuml.hector.SkeletonBuilder;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationUtils;
import net.sourceforge.plantuml.hector.UnlinarCompressedPlan;
import net.sourceforge.plantuml.hector.UnlinearCompression;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CucaDiagramFileMakerHectorB2
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private SkeletonConfiguration configuration;
    private double singleWidth;
    private double singleHeight;
    private double nodeDistanceX = 30.0;
    private double nodeDistanceY = 50.0;
    private UnlinarCompressedPlan unlinarCompressedPlan;
    private final Map<Pin, IEntityImage> images = new LinkedHashMap<Pin, IEntityImage>();
    private final Map<Link, PinLink> links = new LinkedHashMap<Link, PinLink>();

    public CucaDiagramFileMakerHectorB2(CucaDiagram cucaDiagram) {
        this.diagram = cucaDiagram;
    }

    private double getX(Pin pin) {
        return this.nodeDistanceX * (double)this.configuration.getCol(pin);
    }

    private double getY(Pin pin) {
        return this.nodeDistanceY * (double)pin.getRow();
    }

    private Point2D getPoint(Pin pin) {
        return new Point2D.Double(this.getX(pin), this.getY(pin));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImageData createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        void var7_10;
        Object object;
        Object object2;
        PinFactory pinFactory = new PinFactory();
        SkeletonBuilder skeletonBuilder = new SkeletonBuilder();
        this.links.clear();
        for (Link object32 : this.diagram.getLinks()) {
            PinLink pinLink = pinFactory.createPinLink(object32);
            this.links.put(object32, pinLink);
            skeletonBuilder.add(pinLink);
        }
        Skeleton skeleton = skeletonBuilder.createSkeletons().get(0);
        this.configuration = SkeletonConfigurationUtils.getBest(skeleton);
        this.singleWidth = 0.0;
        this.singleHeight = 0.0;
        this.images.clear();
        for (Pin pin : skeleton.getPins()) {
            ILeaf iLeaf = (ILeaf)pin.getUserData();
            object2 = this.computeImage(iLeaf);
            object = TextBlockUtils.getDimension((TextBlock)object2);
            if (((Dimension2D)object).getWidth() > this.singleWidth) {
                this.singleWidth = ((Dimension2D)object).getWidth();
            }
            if (((Dimension2D)object).getHeight() > this.singleHeight) {
                this.singleHeight = ((Dimension2D)object).getHeight();
            }
            this.images.put(pin, (IEntityImage)object2);
        }
        this.unlinarCompressedPlan = new UnlinarCompressedPlan(this.singleWidth, this.nodeDistanceX, this.singleHeight, this.nodeDistanceY);
        MinMax minMax = MinMax.getEmpty(false);
        for (Pin pin : skeleton.getPins()) {
            MinMax minMax2 = var7_10.addPoint(this.unlinarCompressedPlan.uncompress(this.getX(pin), this.getY(pin), UnlinearCompression.Rounding.BORDER_2));
        }
        object2 = new Dimension2DDouble(20.0 + var7_10.getMaxX(), 20.0 + var7_10.getMaxY());
        object = fileFormatOption.createUGraphic(this.diagram.getColorMapper(), this.diagram.getDpiFactor(fileFormatOption), (Dimension2D)object2, null, false);
        object = object.apply(new UTranslate(10.0, 10.0));
        for (PinLink pinLink : skeleton.getPinLinks()) {
            this.drawPinLink((UGraphic)object, pinLink);
        }
        for (Pin pin : skeleton.getPins()) {
            this.drawPin((UGraphic)object, pin);
        }
        object.writeImage(outputStream, null, this.diagram.getDpi(fileFormatOption));
        return new ImageDataSimple((Dimension2D)object2);
    }

    private void drawPin(UGraphic uGraphic, Pin pin) {
        Point2D point2D = this.unlinarCompressedPlan.uncompress(this.getPoint(pin), UnlinearCompression.Rounding.BORDER_1);
        double d = point2D.getX();
        double d2 = point2D.getY();
        URectangle uRectangle = new URectangle(this.unlinarCompressedPlan.getInnerX(), this.unlinarCompressedPlan.getInnerY());
        uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).apply(new UTranslate(d, d2)).draw(uRectangle);
    }

    private void drawPinLink(UGraphic uGraphic, PinLink pinLink) {
        Point2D point2D = this.getPoint(pinLink.getPin1());
        Point2D point2D2 = this.getPoint(pinLink.getPin2());
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(this.diagram.getSkinParam(), ColorParam.classArrow);
        HectorPath hectorPath = this.unlinarCompressedPlan.uncompressSegment(point2D, point2D2);
        hectorPath.draw(uGraphic, htmlColor);
    }

    private IEntityImage computeImage(ILeaf iLeaf) {
        IEntityImage iEntityImage = CucaDiagramFileMakerSvek2.createEntityImageBlock(iLeaf, this.diagram.getSkinParam(), false, this.diagram, null);
        return iEntityImage;
    }
}

