<?php
// This is PML-TQ welcome page
// Michal Sedlak Sun Sep 30 00:01:42 2012
// sedlakmichal@NOSPAM.gmail.com

// Setup:

define('PMLTQ_DIR', '/opt/pmltq'); // no trailing slash
define('PMLTQ_HOST', 'http://euler.ms.mff.cuni.cz'); // no trailing slash

define('PMLTQ_PIDS', PMLTQ_DIR.'/run/running');
// --------------------------------


function get_available_services()
{
    if (!is_dir(PMLTQ_PIDS))
        return;
    
    $services = array();
    foreach (glob(PMLTQ_PIDS . '/pmltq_cgi_*.*') as $filename)
    {
        if (!is_readable($filename))
            continue;
        $content = file_get_contents($filename);
        $parts = array_map('trim', explode("\n", $content));
        $port = $parts[0];
        if (!$port)
            continue;
        $title = preg_replace('/\s+/', ' ', $parts[1]);
        $abstract = preg_replace('/\s+/', ' ', $parts[2]);
        $moreinfo = $parts[3];
        $featured = $parts[4];
        $anonymous = (bool)$parts[5];
        
        $id = explode('.', $filename, 2);
        $id = $id[1];
        
        $services[] = array(
            'id' => $id,
            'port' => $port,
            'title' => $title,
            'abstract' => $abstract,
            'moreinfo' => $moreinfo,
            'featured' => ($featured ? (int)$featured : 10000),
            'anonymous' => $anonymous,
        );
    }
    
    return $services;
}

function is_ssl()
{
    if ( isset($_SERVER['HTTPS']) )
    {
        if ( 'on' == strtolower($_SERVER['HTTPS']) )
            return true;
        if ( '1' == $_SERVER['HTTPS'] )
            return true;
    } elseif ( isset($_SERVER['SERVER_PORT']) && ( '443' == $_SERVER['SERVER_PORT'] ) ) {
        return true;
    }
    return false;
}

function service_cmp($a, $b)
{
    if ($a['anonymous'] != $b['anonymous'])
    {
        return $a['anonymous'] ? -1 : 1;
    }
    
    if ($a['featured'] != $b['featured'])
    {
        return $a['featured'] < $b['featured'] ? -1 : 1;
    }
    
    return strcmp($a['title'], $b['title']);
}

$services = get_available_services();
usort($services, 'service_cmp')
                        
                        // --------------- HTML stuff starts here
?>
<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <title>PML Tree-Query Engine</title>
  <meta name="description" content="">
  <meta name="keywords" content="treebank search query tree constituency dependency">
  <meta name="viewport" content="width=device-width">
  
  <link rel="stylesheet" href="css/normalize.min.css">
  <link rel="stylesheet" href="css/main.css">
  
  <script src="js/vendor/modernizr-2.6.1.min.js"></script>
</head>
<body>
        <!--[if lt IE 7]>
<p class="chromeframe">You are using an outdated browser. <a href="http://browsehappy.com/">Upgrade your browser today</a> or <a href="http://www.google.com/chromeframe/?redirect=true">install Google Chrome Frame</a> to better experience this site.</p>
        <![endif]-->

<h1 id="logo"><a href="<?= (is_ssl() ? 'https' : 'http') . '://' . $_SERVER["HTTP_HOST"] ?>">PML Tree-Query Engine</a></h1>

<nav id="menu">
  <ul>
    <li><a href="http://ufal.mff.cuni.cz/~pajas/pmltq/doc/pmltq_doc.html">Documentation</a></li>
    <li><a href="http://ufal.mff.cuni.cz/~pajas/pmltq/index.html">Project Page</a></li>
  </ul>
</nav>

<h2 id="subtitle">Available Treebanks</h2>
<ul id="services">
<?php
foreach ($services as $service)
{
  $abstract = !empty($service['abstract']);
?>
      <li>
        <?php if ($service['anonymous']) { ?>
        <a title="Search this treebank" class="button" href="<?= PMLTQ_HOST. ':' . $service['port'] ?>">Select</a>
        <span class="icon unlock" title="Public access"><span class="hide">Public</span></span>
        <?php } else { ?>
        <a title="Login is required to access this treebank" class="button" href="<?= PMLTQ_HOST. ':' . $service['port'] ?>">Select</a>
        <span class="icon lock" title="Restricted access"><span class="hide">Restricted</span></span>
        <?php } ?>
        <h3<?php if ($abstract) { ?> class="has-abstract"<?php } ?>><?= htmlspecialchars($service['title']) ?><?php if ($service['abstract']) { ?><span class="more-button">&raquo;</span><span class="less-button">&laquo;</span><?php } ?></h3>
        <?php if ($abstract) { ?>
        <div class="abstract">
          <p><?= htmlspecialchars($service['abstract']) ?></p>
          <a href="<?= $service['moreinfo'] ?>">Click here for more info &hellip;</a>
        </div>
        <?php } ?>
      </li>
<?php
}
?>
    </ul>
    
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.8.1/jquery.min.js"></script>
    <script>window.jQuery || document.write('<script src="js/vendor/jquery-1.8.1.min.js"><\/script>')</script>
    <script src="js/plugins.js"></script>
    <script src="js/main.js"></script>
    <script>
/*            var _gaq=[['_setAccount','UA-XXXXX-X'],['_trackPageview']];
            (function(d,t){var g=d.createElement(t),s=d.getElementsByTagName(t)[0];
            g.src=('https:'==location.protocol?'//ssl':'//www')+'.google-analytics.com/ga.js';
            s.parentNode.insertBefore(g,s)}(document,'script')); */
    </script>
  </body>
</html>

<?php

// Local Variables:
// mode: web
// End:
