# Generated by default/object.tt
package Paws::ComputeOptimizer::EBSFilter;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::EBSFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::EBSFilter object:

  $service_obj->Method(Att1 => { Name => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::EBSFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Describes a filter that returns a more specific list of Amazon Elastic
Block Store (Amazon EBS) volume recommendations. Use this filter with
the C<GetEBSVolumeRecommendations> action.

You can use C<LambdaFunctionRecommendationFilter> with the
C<GetLambdaFunctionRecommendations> action, C<JobFilter> with the
C<DescribeRecommendationExportJobs> action, and C<Filter> with the
C<GetAutoScalingGroupRecommendations> and
C<GetEC2InstanceRecommendations> actions.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the filter.

Specify C<Finding> to return recommendations with a specific finding
classification (e.g., C<NotOptimized>).


=head2 Values => ArrayRef[Str|Undef]

The value of the filter.

The valid values are C<Optimized>, or C<NotOptimized>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

