=begin comment

PeakForest REST API

API specification to support \"PeakForest - REST API\" operations

The version of the OpenAPI document: 2.1.0
Contact: contact@peakforest.org
Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package PeakForest::REST_Client::ApiFactory;

use strict;
use warnings;
use utf8;

use Carp;
use Module::Find;

usesub PeakForest::REST_Client::Object;

use PeakForest::REST_Client::ApiClient;

our $VERSION = '1.00';

=head1 Name

    PeakForest::REST_Client::ApiFactory - constructs APIs to retrieve PeakForest::REST_Client objects

=head1 Synopsis

    package My::Petstore::App;
    
    use PeakForest::REST_Client::ApiFactory;
    
    my $api_factory = PeakForest::REST_Client::ApiFactory->new( ... ); # any args for ApiClient constructor

    # later...
    my $pet_api = $api_factory->get_api('Pet');  
    
    # $pet_api isa PeakForest::REST_Client::PetApi
    
    my $pet = $pet_api->get_pet_by_id(pet_id => $pet_id);

    # object attributes have proper accessors:
    printf "Pet's name is %s", $pet->name;

    # change the value stored on the object:
    $pet->name('Dave'); 

=cut

# Load all the API classes and construct a lookup table at startup time
my %_apis = map { $_ =~ /^PeakForest::REST_Client::(.*)$/; $1 => $_ } 
            grep {$_ =~ /Api$/} 
            usesub 'PeakForest::REST_Client';

=head1 new($api_client)
    
    create a new PeakForest::REST_Client::ApiFactory instance with the given PeakForest::REST_Client::ApiClient instance.

=head1 new(%parameters)

    Any parameters are optional, and are passed to and stored on the api_client object.
    
    See L<PeakForest::REST_Client::ApiClient> and L<PeakForest::REST_Client::Configuration> for valid parameters

=cut    

sub new {
    my ($class) = shift;

    my $api_client;
    if ($_[0] && ref $_[0] && ref $_[0] eq 'PeakForest::REST_Client::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = PeakForest::REST_Client::ApiClient->new(@_);
    }
    bless { api_client => $api_client }, $class;
}

=head1 get_api($which)

    Returns an API object of the requested type. 
    
    $which is a nickname for the class: 
    
        FooBarClient::BazApi has nickname 'Baz'
        
=cut

sub get_api {
    my ($self, $which) = @_;
    croak "API not specified" unless $which;
    my $api_class = $_apis{"${which}Api"} || croak "No known API for '$which'";
    return $api_class->new($self->api_client); 
}

=head1 api_client()

    Returns the api_client object, should you ever need it.
    
=cut

sub api_client { $_[0]->{api_client} }

=head1 apis_available()
=cut 

sub apis_available { return map { $_ =~ s/Api$//; $_ } sort keys %_apis }

=head1 classname_for()
=cut

sub classname_for {
    my ($self, $api_name) = @_;
    return $_apis{"${api_name}Api"};
}


1;
