﻿//------------------------------------------------------------------------------
// <copyright company="DMV">
//   Copyright 2014 Ded Medved
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.
// </copyright>
//------------------------------------------------------------------------------
using System.Collections.Generic;
using Microsoft.SqlServer.TransactSql.ScriptDom;
using System.IO;

namespace Cheburashka
{
    internal class AvoidDirectUseOfRowcountVisitor : TSqlConcreteFragmentVisitor
    {
        public AvoidDirectUseOfRowcountVisitor()
        {
            GlobalVariableExpressions = new List<GlobalVariableExpression>();
        }

        public IList<GlobalVariableExpression> GlobalVariableExpressions { get; private set; }



        public override void ExplicitVisit(GlobalVariableExpression node)
        {
            //using (StreamWriter w = File.AppendText(@"c:\temp\blah.txt"))
            //{


            //    w.WriteLine(node.Name);
            //}

            //if (SqlComparer.SQLModel_StringCompareEqual(node.Name, "@@rowcount")
            //    || SqlComparer.SQLModel_StringCompareEqual(node.Name, "@@error")
            if (node.Name.SQLModel_StringCompareEqual("@@rowcount")
                || node.Name.SQLModel_StringCompareEqual("@@error")
                )
            {
                GlobalVariableExpressions.Add(node);
            }
        }

    }
}
