use Test::Simple tests => 18;
use Chess::Piece;
use strict;

my $piece = Chess::Piece->new("e2", "white", "White King's pawn");
ok( $piece );
$piece->set_current_square("e4");
ok( $piece->get_initial_square() eq "e2" );
ok( $piece->get_current_square() eq "e4" );
ok( $piece->get_player() eq "white" );
ok( $piece->get_description() eq "White King's pawn" );
$piece->set_description("test");
ok( $piece->get_description() eq "test" );
my $clone = $piece->clone();
$clone->set_current_square("e5");
ok( $piece->get_current_square() eq "e4" );
ok( $clone->get_current_square() eq "e5" );
ok( !$piece->moved() );
$piece->set_moved(1);
ok( $piece->moved() );
ok( !$piece->threatened() );
$piece->set_threatened(1);
ok( $piece->threatened() );
ok( !$piece->captured() );
$piece->set_captured(1);
ok( !defined($piece->get_current_square()) );
ok( $piece->captured() );
$piece->set_moved(0);
ok( !$piece->moved() );
$piece->set_captured(0);
ok( !$piece->captured() );
$piece->set_threatened(0);
ok( !$piece->threatened() );
